#!/bin/bash
cd "$(dirname "$0")"

# -----------------------------------------------------------------------------
# Control FMLLMOS Node
#
# Copyright: © 2015-2025 Claris International Inc. All rights reserved.
#
# Environment Variable Prerequisites
#
#   ARGS     start, stop.
#
# -----------------------------------------------------------------------------
case "$(uname -s)" in
    Darwin)
        export HOME="/Library/FileMakerLLM"
        ;;
    Linux)
        export HOME="/opt/FileMaker"
         ;;
esac
echo "Arguments: $@"
DEBUG=0

FMOSLLM_COMP="FMS.COMPONENT=fmosllm"

if [ "$1" = "start" ] ; then
  echo "Starting FMLLMOS node"
  shift

  if [ "$1" = "-debug" ]; then
    shift
    DEBUG=1
    export HOME="$PWD/../.."
  fi

  miniforge_dir="$HOME/Open_Source_LLM/server/miniforge3"
  logs_file="$miniforge_dir/../fm_LLMOS_Debug.txt"
  env_name="fmosllm"

  echo "Starting Server" >> "$logs_file" 2>&1
  if [ $DEBUG == 1 ] ; then
    echo "$miniforge_dir/bin/conda run -p "$miniforge_dir/envs/$env_name" bash -c python fm_LLMOS_StartServer.py -bridge -debug $FMOSLLM_COMP >> '$logs_file' 2>&1"
    "$miniforge_dir/bin/conda" run -p "$miniforge_dir/envs/$env_name" bash -c "python fm_LLMOS_StartServer.py -bridge -debug $FMOSLLM_COMP >> '$logs_file' 2>&1"
  else
    "$miniforge_dir/bin/conda" run -p "$miniforge_dir/envs/$env_name" bash -c "python fm_LLMOS_StartServer.pyc -bridge $FMOSLLM_COMP >> '$logs_file' 2>&1"
  fi
elif [ "$1" = "stop" ] ; then
  echo "Stopping FMLLMOS node"

  shift
  FORCE=0
  if [ "$1" = "-force" ]; then
    shift
    FORCE=1
  fi

  # if [ "$1" = "-h" ]; then
  #   HASH=$1
  #   shift
  # fi

  if [[ "$(uname)" == "Linux" ]]; then
    FMLLMOS_PID=$(ps -Af | grep "fm_LLMOS_StartServer.py" | grep "bridge" | grep -v "conda" | awk '{print $2}' | tail -n 1)
  else
    FMLLMOS_PID=$(ps -A | grep "python fm_LLMOS_StartServer.py" | grep "bridge" | grep -v "conda" | awk '{print $1}' | tail -n 1)
  fi
  FMLLMOS_PID_NAME=$(ps -p $FMLLMOS_PID -o comm=)

  echo PID: $FMLLMOS_PID >> "$logs_file" 2>&1
  echo PID NAME: $FMLLMOS_PID_NAME >> "$logs_file" 2>&1

  if [ "$FMLLMOS_PID_NAME" = "python" ]; then
     # force kill
    if [ $FORCE -eq 1 ]; then
      echo "Killing: $FMLLMOS_PID" >> "$logs_file" 2>&1
      kill -USR1 $FMLLMOS_PID

    else
      echo "Killing: $FMLLMOS_PID" >> "$logs_file" 2>&1
      kill $FMLLMOS_PID
    fi
  else
    echo "PID $FMLLMOS_PID is not running or is not 'FMLLMOS node'" >> "$logs_file" 2>&1
  fi

else

  echo "Usage: llmosdeploy.sh ( commands ... )"
  echo "commands:"
  echo "  start                 Start FMLLMOS node in a separate window"
  echo "  stop -k               Stop FMLLMOS node"
  echo "  stop -force           Stop FMLLMOS node with key forcefully"
  exit 1

fi
exit 0
